VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{637623F6-46FF-4190-A20A-3CD87DE1F7A5}#1.0#0"; "PIXTWIXLIB.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   8310
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   9840
   LinkTopic       =   "Form1"
   ScaleHeight     =   8310
   ScaleWidth      =   9840
   StartUpPosition =   3  'Windows Default
   WindowState     =   2  'Maximized
   Begin PixTwixLib.PixTwix PixTwix 
      Left            =   8640
      Top             =   240
      Picture         =   "Form1.frx":0000
      SecondaryPicture=   "Form1.frx":323636
   End
   Begin VB.CommandButton btnReload 
      Caption         =   "Reload image"
      Height          =   375
      Left            =   5093
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin MSComDlg.CommonDialog dlgColor 
      Left            =   8040
      Top             =   240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton btnUndo 
      Caption         =   "Undo effect"
      Height          =   375
      Left            =   3533
      TabIndex        =   1
      Top             =   240
      Width           =   1335
   End
   Begin VB.PictureBox Display 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   7200
      Left            =   120
      ScaleHeight     =   7200
      ScaleWidth      =   9600
      TabIndex        =   0
      Top             =   960
      Width           =   9600
   End
   Begin VB.Menu miAttributes 
      Caption         =   "Attributes"
      Begin VB.Menu miAttributesBrightness 
         Caption         =   "Brightness"
      End
      Begin VB.Menu miAttributesContrast 
         Caption         =   "Contrast"
      End
      Begin VB.Menu miAttributesSaturation 
         Caption         =   "Saturation"
      End
   End
   Begin VB.Menu miBorder 
      Caption         =   "Border"
      Begin VB.Menu miBorderErode 
         Caption         =   "Erode border"
      End
      Begin VB.Menu miBorderFrame 
         Caption         =   "Draw frame"
      End
      Begin VB.Menu miBorderCanvas 
         Caption         =   "Paint on canvas"
      End
   End
   Begin VB.Menu miColor 
      Caption         =   "Color"
      Begin VB.Menu miColorBW 
         Caption         =   "Black and white"
      End
      Begin VB.Menu miColorBWD 
         Caption         =   "Black and white dithered"
      End
      Begin VB.Menu miColorColorize 
         Caption         =   "Colorize"
      End
      Begin VB.Menu miColorGrayscale 
         Caption         =   "Grayscale"
      End
      Begin VB.Menu miColorPosterize 
         Caption         =   "Posterize"
      End
      Begin VB.Menu miColorTint 
         Caption         =   "Tint"
      End
   End
   Begin VB.Menu miFlip 
      Caption         =   "Flip, etc."
      Begin VB.Menu miFlipFlip 
         Caption         =   "Flip"
      End
      Begin VB.Menu miFlipReverse 
         Caption         =   "Reverse"
      End
      Begin VB.Menu miFlipReflectL 
         Caption         =   "Reflect left"
      End
      Begin VB.Menu miFlipReflectR 
         Caption         =   "Reflect right"
      End
      Begin VB.Menu miFlipReflectT 
         Caption         =   "Reflect top"
      End
      Begin VB.Menu miFlipReflectB 
         Caption         =   "Reflect bottom"
      End
   End
   Begin VB.Menu miRotation 
      Caption         =   "Rotation"
      Begin VB.Menu miRotationRotate90 
         Caption         =   "Rotate 90 degrees"
      End
      Begin VB.Menu miRotationRotate180 
         Caption         =   "Rotate 180 degrees"
      End
      Begin VB.Menu miRotationRotate270 
         Caption         =   "Rotate 270 degrees"
      End
      Begin VB.Menu miRotationRotateClip 
         Caption         =   "Rotate with clipping"
      End
      Begin VB.Menu miRotationRotateNoClip 
         Caption         =   "Rotate without clipping"
      End
   End
   Begin VB.Menu miSecurity 
      Caption         =   "Security"
      Begin VB.Menu miSecurityEncrypt 
         Caption         =   "Encrypt"
      End
      Begin VB.Menu miSecurityDecrypt 
         Caption         =   "Decrypt"
      End
   End
   Begin VB.Menu miSize 
      Caption         =   "Size"
      Begin VB.Menu miSizeCropResize 
         Caption         =   "Crop and resize"
      End
   End
   Begin VB.Menu miShapness 
      Caption         =   "Sharpness"
      Begin VB.Menu miSharpnessAntialias 
         Caption         =   "Antialias"
      End
      Begin VB.Menu miSharpnessBlur 
         Caption         =   "Blur"
      End
      Begin VB.Menu miSharpnessSoften 
         Caption         =   "Soften"
      End
      Begin VB.Menu miSharpnessEnhanceEdge 
         Caption         =   "Enhance edge"
      End
      Begin VB.Menu miSharpnessSharpen 
         Caption         =   "Sharpen"
      End
   End
   Begin VB.Menu miSFX 
      Caption         =   "Special FX"
      Begin VB.Menu miSFXNoise 
         Caption         =   "Add noise"
      End
      Begin VB.Menu miSFXBlend 
         Caption         =   "Blend"
      End
      Begin VB.Menu miSFXEmboss 
         Caption         =   "Emboss"
      End
      Begin VB.Menu miSFXLoupe 
         Caption         =   "Loupe"
      End
      Begin VB.Menu miSFXMosaic 
         Caption         =   "Mosaic"
      End
      Begin VB.Menu miSFXScramble 
         Caption         =   "Scramble"
      End
      Begin VB.Menu miSFXSolarize 
         Caption         =   "Solarize"
      End
      Begin VB.Menu miSFXSpray 
         Caption         =   "Spray"
      End
      Begin VB.Menu miSFXTexture 
         Caption         =   "Texture"
      End
      Begin VB.Menu miSFXTile 
         Caption         =   "Tile"
      End
      Begin VB.Menu miSFXTwirl 
         Caption         =   "Twirl"
      End
      Begin VB.Menu miSFXStaggerRows 
         Caption         =   "Stagger rows"
      End
      Begin VB.Menu miSFXStaggerColumns 
         Caption         =   "Stagger columns"
      End
   End
   Begin VB.Menu miSelections 
      Caption         =   "Selections"
      Begin VB.Menu miSelectionsSelInv 
         Caption         =   "Select irregular region and invert selected"
      End
      Begin VB.Menu miSelectionsSelTexture 
         Caption         =   "Select irregular region and apply texture to selection"
      End
      Begin VB.Menu miSelectionsSelGlobalMWMaskNS 
         Caption         =   "Select using global magic wand and mask not selected"
      End
   End
   Begin VB.Menu miZoom 
      Caption         =   "Zoom"
      Begin VB.Menu miZoomFree 
         Caption         =   "Free zoom"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
  Dim undo_file As String
  Dim magnification As Long
  Dim zoomed_left As Long
  Dim zoomed_top As Long
  Dim effect As Integer
  Const MSG_LOUPE = "Click anywhere on image to see LOUPE effect"
  Const FX_LOUPE = 0
  Const MSG_TWIRL = "Click anywhere on image to see TWIRL effect"
  Const FX_TWIRL = 1
  Const MSG_ZOOM = "Left click to zoom in, right click to zoom out"
  Const FX_ZOOM = 2
  Const MSG_MAGICWAND = "Click anywhere inside area you want to select"
  Const FX_MAGICWAND = 3
  
Private Sub Prepare()
  ' assigns image data to Picture property and prepares undo
  PixTwix.Picture = Display.Picture
  If PixTwix.UndoSave(undo_file) Then
    btnUndo.Enabled = True
  Else
    btnUndo.Enabled = False
  End If
End Sub

Private Sub Update()
  ' gets processed image data and displays it
  Set Display.Picture = PixTwix.Picture
End Sub

Private Sub Message()
  Dim msg As String
  Dim line As String
  Dim ff As Integer
  ff = FreeFile
  Open App.Path & "\demo.txt" For Input As #ff
  Do Until EOF(ff)
    Line Input #ff, line
    msg = msg + line + vbCrLf
  Loop
  Close #ff
  MsgBox msg, vbInformation
End Sub

Private Sub btnReload_Click()
  Display.Picture = LoadPicture(App.Path & "\kids.jpg")
  effect = -1
  magnification = 1
  zoomed_left = 0
  zoomed_top = 0
End Sub

Private Sub btnUndo_Click()
  If PixTwix.UndoLoad(undo_file) Then
    Update
    btnUndo.Enabled = False
  End If
End Sub

Private Sub Display_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Dim cx As Long
  Dim cy As Long
 
 
  Select Case effect
  
    Case FX_LOUPE
      Prepare
      If PixTwix.Loupe(X, Y, 120, 60) Then Update
      
    Case FX_TWIRL
      Prepare
      If PixTwix.Twirl(X, Y, 120) Then Update
      
    Case FX_ZOOM
      cx = zoomed_left + X \ magnification
      cy = zoomed_top + Y \ magnification
      If Button = vbLeftButton Then
        magnification = magnification * 2
      ElseIf Button = vbRightButton Then
        magnification = magnification \ 2
      End If
      If magnification < 1 Then magnification = 1
      If PixTwix.Zoom(cx, cy, magnification) Then Set Display.Picture = PixTwix.SecondaryPicture
      zoomed_left = PixTwix.GetZoomedLeft
      zoomed_top = PixTwix.GetZoomedTop
      
    Case FX_MAGICWAND
      PixTwix.SelectNone
      PixTwix.SelectUsingGlobalMagicWand X, Y, 15, mwRGB
      If PixTwix.MaskNotSelected(0, 0, 0) Then Update
  End Select

End Sub

Private Sub Form_Load()
  Display.ScaleMode = vbPixels ' THIS IS VERY IMPORTANT !!!
  PixTwix.Unlock ("your registration code here")
  Me.Caption = "PixTwix " & PixTwix.GetVersion & " demo project"
  btnUndo.Enabled = False
  Display.Picture = LoadPicture(App.Path & "\kids.jpg")
  undo_file = App.Path & "\undo.bmp"
  effect = -1
  magnification = 1
  zoomed_left = 0
  zoomed_top = 0
  Message
End Sub

Private Sub miAttributesBrightness_Click()
  Prepare
  If PixTwix.Brightness(20, False) Then Update
End Sub

Private Sub miAttributesContrast_Click()
  Prepare
  If PixTwix.Contrast(30, False) Then Update
End Sub

Private Sub miAttributesSaturation_Click()
  Prepare
  If PixTwix.Saturation(20, False) Then Update
End Sub

Private Sub miBorderCanvas_Click()
  Dim w As Long
  Dim h As Long
  Prepare
  w = PixTwix.GetPictureWidth
  h = PixTwix.GetPictureHeight
  If PixTwix.PaintOnCanvas(w + 50, h + 50, 25, 25, 255, 255, 255, 10, 10, 6, 128, 128, 128) Then Update
End Sub

Private Sub miBorderErode_Click()
  Prepare
  If PixTwix.ErodeBorder(20, 255, 255, 255) Then Update
End Sub

Private Sub miBorderFrame_Click()
  Prepare
  If PixTwix.Frame(16, 50, 50, 250, 220, 220, 220) Then Update
End Sub

Private Sub miColorBW_Click()
  Prepare
  If PixTwix.BlackAndWhite(127, False) Then Update
End Sub

Private Sub miColorBWD_Click()
  Prepare
  If PixTwix.BlackAndWhiteDithered(0, False) Then Update
End Sub

Private Sub miColorColorize_Click()
  Dim R As Long
  Dim G As Long
  Dim B As Long
  dlgColor.ShowColor
  R = PixTwix.GetRed(dlgColor.Color)
  G = PixTwix.GetGreen(dlgColor.Color)
  B = PixTwix.GetBlue(dlgColor.Color)
  Prepare
  If PixTwix.Colorize(R, G, B, False) Then Update
End Sub

Private Sub miColorGrayscale_Click()
  Prepare
  If PixTwix.Grayscale(gsWeighted, False) Then Update
End Sub

Private Sub miColorPosterize_Click()
  Prepare
  If PixTwix.Posterize(3, 3, 3, False) Then Update
End Sub

Private Sub miColorTint_Click()
  Dim R As Long
  Dim G As Long
  Dim B As Long
  dlgColor.ShowColor
  R = PixTwix.GetRed(dlgColor.Color)
  G = PixTwix.GetGreen(dlgColor.Color)
  B = PixTwix.GetBlue(dlgColor.Color)
  Prepare
  If PixTwix.Tint(R, G, B, False) Then Update
End Sub

Private Sub miFlipFlip_Click()
  Prepare
  If PixTwix.Flip Then Update
End Sub

Private Sub miFlipReflectB_Click()
  Prepare
  If PixTwix.Reflect(rmBottom) Then Update
End Sub

Private Sub miFlipReflectL_Click()
  Prepare
  If PixTwix.Reflect(rmLeft) Then Update
End Sub

Private Sub miFlipReflectR_Click()
  Prepare
  If PixTwix.Reflect(rmRight) Then Update
End Sub

Private Sub miFlipReflectT_Click()
  Prepare
  If PixTwix.Reflect(rmTop) Then Update
End Sub

Private Sub miFlipReverse_Click()
  Prepare
  If PixTwix.Reverse Then Update
End Sub

Private Sub miRotationRotate180_Click()
  Prepare
  If PixTwix.Rotate180 Then Update
End Sub

Private Sub miRotationRotate270_Click()
  Prepare
  If PixTwix.Rotate270 Then Update
End Sub

Private Sub miRotationRotate90_Click()
  Prepare
  If PixTwix.Rotate90 Then Update
End Sub

Private Sub miRotationRotateClip_Click()
  Dim cx As Long
  Dim cy As Long
  Prepare
  cx = PixTwix.GetPictureWidth \ 2
  cy = PixTwix.GetPictureHeight \ 2
  If PixTwix.RotatePicture(cx, cy, 45, 255, 255, 255) Then Update
End Sub

Private Sub miRotationRotateNoClip_Click()
  Prepare
  If PixTwix.RotatePictureEx(45, 255, 255, 255) Then Update
End Sub

Private Sub miSecurityDecrypt_Click()
   Prepare
   Dim password As String
   password = InputBox("", "Password")
   If PixTwix.Decrypt(password) Then Update
End Sub

Private Sub miSecurityEncrypt_Click()
   Dim password As String
   Prepare
   password = InputBox("", "Password")
   If PixTwix.Encrypt(password) Then Update
End Sub

Private Sub miSelectionsSelGlobalMWMaskNS_Click()
  Display.Picture = LoadPicture(App.Path & "\kids.jpg")
  Prepare
  MsgBox MSG_MAGICWAND, vbInformation
  effect = FX_MAGICWAND
End Sub

Private Sub miSelectionsSelInv_Click()
  Display.Picture = LoadPicture(App.Path & "\kids.jpg")
  Prepare
  PixTwix.SelectNone
  PixTwix.SelectEllipse 10, 10, 250, 200
  PixTwix.SelectEllipse 400, 70, 635, 500
  If PixTwix.Negative(True, True, True, True) Then Update
End Sub

Private Sub miSelectionsSelTexture_Click()
  Display.Picture = LoadPicture(App.Path & "\kids.jpg")
  Prepare
  PixTwix.SelectNone
  PixTwix.SelectEllipse 10, 10, 250, 200
  PixTwix.SelectEllipse 400, 70, 635, 500
  PixTwix.SecondaryPicture = LoadPicture(App.Path & "\texture.jpg")
  If PixTwix.Texture(0, tmStretched, True) Then Update
End Sub

Private Sub miSFXBlend_Click()
  Prepare
  PixTwix.SecondaryPicture = LoadPicture(App.Path & "\sunset.jpg")
  If PixTwix.Blend(50, 50, False) Then Update
End Sub

Private Sub miSFXEmboss_Click()
  Prepare
  If PixTwix.Emboss(edNorthEast, 3, 127, False) Then Update
End Sub

Private Sub miSFXLoupe_Click()
  MsgBox MSG_LOUPE, vbInformation
  effect = FX_LOUPE
End Sub

Private Sub miSFXMosaic_Click()
  Prepare
  If PixTwix.Mosaic(10, 10, False) Then Update
End Sub

Private Sub miSFXNoise_Click()
  Prepare
  If PixTwix.AddNoise(50, True, False) Then Update
End Sub

Private Sub miSFXScramble_Click()
  Prepare
  If PixTwix.Scramble(100, 75) Then Update
End Sub

Private Sub miSFXSolarize_Click()
  Prepare
  If PixTwix.Solarize(80, 80, 80, True, False) Then Update
End Sub

Private Sub miSFXSpray_Click()
  Prepare
  If PixTwix.Spray(20, False) Then Update
End Sub

Private Sub miSFXStaggerColumns_Click()
  Dim i As Integer
  Prepare
  For i = 1 To 5
    PixTwix.StaggerColumns True
  Next
  Update
End Sub

Private Sub miSFXStaggerRows_Click()
  Dim i As Integer
  Prepare
  For i = 1 To 5
    PixTwix.StaggerRows True
  Next
  Update
End Sub

Private Sub miSFXTexture_Click()
  Prepare
  PixTwix.SecondaryPicture = LoadPicture(App.Path & "\texture.jpg")
  If PixTwix.Texture(0, tmStretched, False) Then Update
End Sub

Private Sub miSFXTile_Click()
  Prepare
  If PixTwix.TileEx(100, 75) Then Update
End Sub

Private Sub miSFXTwirl_Click()
  MsgBox MSG_TWIRL, vbInformation
  effect = FX_TWIRL
End Sub

Private Sub miSharpnessAntialias_Click()
  Prepare
  If PixTwix.Antialias(False) Then Update
End Sub

Private Sub miSharpnessBlur_Click()
  Prepare
  If PixTwix.BlurMore(False) Then Update
End Sub

Private Sub miSharpnessEnhanceEdge_Click()
  Prepare
  If PixTwix.EnhanceEdge(False) Then Update
End Sub

Private Sub miSharpnessSharpen_Click()
  Prepare
  If PixTwix.Sharpen(False) Then Update
End Sub

Private Sub miSharpnessSoften_Click()
  Prepare
  If PixTwix.SoftenMore(False) Then Update
End Sub

Private Sub miSizeCropResize_Click()
  Prepare
  If PixTwix.CropPicture(0, 0, 400, 300) Then If PixTwix.ResizePicture(640, 480, True) Then Update
End Sub

Private Sub miZoomFree_Click()
  Prepare
  MsgBox MSG_ZOOM, vbInformation
  effect = FX_ZOOM
End Sub

